
    <style>

        .container {
            margin: 0 auto;
            background: white;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h1, h2 {
            color: #333;
        }
        .error {
            background: #f8d7da;
            color: #721c24;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 20px;
            border: 1px solid #f5c6cb;
        }
        .property-card {
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 15px;
            margin-bottom: 15px;
            transition: all 0.3s ease;
        }
        .property-card:hover {
            border-color: #007bff;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .property-card h3 {
            margin-top: 0;
            color: #007bff;
        }
        .property-details {
            margin-bottom: 10px;
            color: #666;
        }
        .property-badge {
            display: inline-block;
            background: #007bff;
            color: white;
            padding: 2px 8px;
            border-radius: 3px;
            font-size: 12px;
            margin-right: 5px;
        }
        .property-select {
            background: #007bff;
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
        }
        .property-select:hover {
            background: #0056b3;
        }
        .back-button {
            display: inline-block;
            background: #6c757d;
            color: white;
            text-decoration: none;
            padding: 8px 15px;
            border-radius: 4px;
            margin-top: 20px;
        }
    </style>

    <div class="container-xxl flex-grow-1 container-p-y">
        <h1>Select Google Analytics Property</h1>
        
        <?php if (isset($error)): ?>
            <div class="error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        

        
        <?php if (empty($properties)): ?>
            <p>No Google Analytics properties found. Please make sure you have access to Google Analytics.</p>
            <a href="<?php echo $pluginURL.'&route=connect'?>" class="back-button">Try Again</a>
        <?php else: ?>
            <p>Please select the Google Analytics property you want to connect:</p>
            
            <?php foreach ($properties as $property): ?>
                <div class="property-card">
                    <h3><?php echo htmlspecialchars($property['name']); ?></h3>
                    <div class="property-details">
                        <div><strong>Property ID:</strong> <?php echo htmlspecialchars($property['propertyId']); ?></div>
                        <div><strong>Account:</strong> <?php echo htmlspecialchars($property['accountName']); ?></div>
                        <div><span class="property-badge"><?php echo htmlspecialchars($property['type']); ?></span></div>
                    </div>
                    <form method="post" action="">
                        <input type="hidden" name="property_id" value="<?php echo htmlspecialchars($property['propertyId']); ?>">
                        <input type="hidden" name="property_name" value="<?php echo htmlspecialchars($property['name']); ?>">
                        <input type="hidden" name="account_id" value="<?php echo htmlspecialchars($property['accountId']); ?>">
                        <input type="hidden" name="account_name" value="<?php echo htmlspecialchars($property['accountName']); ?>">
                        <button type="submit" class="property-select">Select This Property</button>
                    </form>
                </div>
            <?php endforeach; ?>
            
            <a href="<?php echo $pluginURL.'&route=connect'?>" class="back-button btn btn-primary">Back</a>
        <?php endif; ?>
    </div>
