
    <style>
        
        .container {
            max-width: 900px;
            margin: 0 auto;
            padding: 20px;
        }
        
        .header {
            background: linear-gradient(135deg, #4a6bff 0%, #2e3b8e 100%);
            color: white;
            padding: 30px 20px;
            border-radius: 10px;
            text-align: center;
            margin-bottom: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        
        .header h1 {
            font-size: 2.2em;
            margin-bottom: 10px;
            font-weight: 600;
        }
        
        .header p {
            font-size: 1.1em;
            opacity: 0.9;
        }
        
        .logo {
            max-width: 200px;
            margin-bottom: 15px;
        }
        
        .content-section {
            background: white;
            border-radius: 10px;
            padding: 25px;
            margin-bottom: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .step-title {
            font-size: 1.6em;
            color: #2c3e50;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 15px;
            border-bottom: 2px solid #f1f1f1;
            padding-bottom: 10px;
        }
        
        .step-icon {
            background: linear-gradient(135deg, #4a6bff 0%, #2e3b8e 100%);
            color: white;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2em;
        }
        
        .substep {
            margin: 20px 0;
            padding: 15px;
            background: #f8f9fa;
            border-left: 4px solid #4a6bff;
            border-radius: 0 5px 5px 0;
        }
        
        .substep h4 {
            color: #4a6bff;
            margin-bottom: 10px;
            font-size: 1.1em;
        }
        
        .warning {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            color: #856404;
            padding: 15px;
            border-radius: 5px;
            margin: 15px 0;
        }
        
        .warning::before {
            content: "⚠️ ";
            font-weight: bold;
        }
        
        .success {
            background: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
            padding: 15px;
            border-radius: 5px;
            margin: 15px 0;
        }
        
        .success::before {
            content: "✅ ";
            font-weight: bold;
        }
        
        .info {
            background: #d1ecf1;
            border: 1px solid #bee5eb;
            color: #0c5460;
            padding: 15px;
            border-radius: 5px;
            margin: 15px 0;
        }
        
        .info::before {
            content: "ℹ️ ";
            font-weight: bold;
        }
        
        .image-container {
            margin: 20px 0;
            text-align: center;
        }
        
        .image-container img {
            max-width: 100%;
            border: 1px solid #ddd;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        
        .image-caption {
            margin-top: 10px;
            font-size: 0.9em;
            color: #666;
        }
        
        ol, ul {
            margin-left: 20px;
            margin-bottom: 15px;
        }
        
        li {
            margin-bottom: 8px;
        }
        
        .button {
            display: inline-block;
            background: linear-gradient(135deg, #4a6bff 0%, #2e3b8e 100%);
            color: white;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 5px;
            font-weight: 500;
            transition: transform 0.2s;
            border: none;
            cursor: pointer;
            font-size: 14px;
            margin-top: 10px;
        }
        
        .button:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }
        
        .button.secondary {
            background: #6c757d;
        }
        
        .navigation {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin: 30px 0;
        }
        
        .toc {
            background: white;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .toc h3 {
            margin-bottom: 15px;
            color: #2c3e50;
        }
        
        .toc ul {
            list-style: none;
            padding: 0;
            margin-left: 0;
        }
        
        .toc li {
            padding: 8px 0;
            border-bottom: 1px solid #f1f1f1;
        }
        
        .toc a {
            color: #4a6bff;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .toc a:hover {
            text-decoration: underline;
        }
        
        .screenshot {
            border: 1px solid #ddd;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            max-width: 100%;
            height: auto;
            margin: 15px 0;
        }
        
        .highlight-box {
            background: #f8f9fa;
            border: 1px solid #e9ecef;
            border-radius: 5px;
            padding: 15px;
            margin: 15px 0;
        }
        
        .highlight-box h4 {
            margin-bottom: 10px;
            color: #2c3e50;
        }
        
        .code-snippet {
            background: #f8f9fa;
            border: 1px solid #e9ecef;
            border-radius: 5px;
            padding: 15px;
            margin: 15px 0;
            font-family: monospace;
            white-space: pre-wrap;
            overflow-x: auto;
        }
        
        @media (max-width: 768px) {
            .container {
                padding: 10px;
            }
            
            .header h1 {
                font-size: 1.8em;
            }
            
            .content-section {
                padding: 15px;
            }
            
            .navigation {
                flex-direction: column;
                gap: 15px;
            }
        }
    </style>

    <div class="container-xxl flex-grow-1 container-p-y">
        <!-- Header -->
        <div class="header">
            <h1>Google Analytics Integration</h1>
            <p>Setup Guide for NovelEngine V2.0 Plugin</p>
        </div>
        
        <!-- Table of Contents -->
        <div class="toc">
            <h3>📋 Table of Contents</h3>
            <ul>
                <li><a href="#step1">🔍 Step 1: Create Google Analytics Account & Property</a></li>
                <li><a href="#step2">🔧 Step 2: Set Up Google Cloud Project</a></li>
                <li><a href="#step3">🔑 Step 3: Create OAuth Credentials</a></li>
                <li><a href="#step4">📚 Step 4: Enable Required APIs</a></li>
                <li><a href="#step5">🔄 Step 5: Configure NovelEngine Plugin</a></li>
            </ul>
        </div>
        
        <!-- Step 1: Google Analytics Account -->
        <div class="content-section" id="step1">
            <h2 class="step-title">
                <div class="step-icon">🔍</div>
                Step 1: Create Google Analytics Account & Property
            </h2>
            
            <div class="substep">
                <h4>1.1: Sign in to Google Analytics</h4>
                <ol>
                    <li>Go to <a href="https://analytics.google.com" target="_blank">https://analytics.google.com</a></li>
                    <li>Sign in with your Google account (create one if needed)</li>
                    <li>If you're new to Google Analytics, click the "Start measuring" button</li>
                </ol>
                
                  <div class="image-container">
                    <img src="<?php echo APP_URL.'/plugins/google-analytics/views/screenshot/1.png'?>" alt="Google Analytics sign-in page" class="screenshot">
                    <p class="image-caption">Google Analytics sign-in page</p>
                </div>
                
                
     
            </div>
            
            <div class="substep">
                <h4>1.2: Create a Google Analytics Account</h4>
                <ol>
                    <li>Enter an Account Name (typically your organization name)</li>
                    <li>Configure data sharing settings based on your preferences</li>
                    <li>Click "Next" to continue</li>
                </ol>
                
                <div class="info">
                    The account is the top-level organization of your Analytics resources. You can have multiple properties under one account.
                </div>
            </div>
            
            <div class="substep">
                <h4>1.3: Set Up a Google Analytics Property</h4>
                <ol>
                    <li>Enter a Property Name (typically your website or application name)</li>
                    <li>Select your reporting time zone and currency</li>
                    <li>Click "Next" to continue</li>
                    <li>Provide business information as requested (industry, size, etc.)</li>
                    <li>Select how you intend to use Google Analytics</li>
                    <li>Click "Create" to finish property setup</li>
                </ol>
                
                <div class="image-container">
                    <img src="<?php echo APP_URL.'/plugins/google-analytics/views/screenshot/2.png'?>" alt="Creating GA4 Property" class="screenshot">
                    <p class="image-caption">Creating a GA4 property</p>
                </div>
                
                <div class="success">
                    After completing these steps, you'll be taken to your Google Analytics dashboard with your new property created.
                </div>
            </div>
            
        </div>
        
        <!-- Step 2: Google Cloud Project -->
        <div class="content-section" id="step2">
            <h2 class="step-title">
                <div class="step-icon">🔧</div>
                Step 2: Set Up Google Cloud Project
            </h2>
            
            <div class="substep">
                <h4>2.1: Access Google Cloud Console</h4>
                <ol>
                    <li>Go to <a href="https://console.cloud.google.com/" target="_blank">https://console.cloud.google.com/</a></li>
                    <li>Sign in with the same Google account you used for Analytics</li>
                </ol>
            </div>
            
            <div class="substep">
                <h4>2.2: Create a New Project</h4>
                <ol>
                    <li>Click on the project dropdown at the top of the page</li>
                    <li>Click "New Project"</li>
                    <li>Enter a Project Name (e.g., "NovelEngine Analytics")</li>
                    <li>Optionally select an organization</li>
                    <li>Click "Create"</li>
                </ol>
                
                <div class="image-container">
                    <img src="<?php echo APP_URL.'/plugins/google-analytics/views/screenshot/3.png'?>" alt="Creating Google Cloud Project" class="screenshot">
                    <p class="image-caption">Creating a new Google Cloud project</p>
                </div>
                
                <div class="info">
                    After creation, Google Cloud will automatically select your new project. If not, select it from the project dropdown at the top of the page.
                </div>
            </div>
            
            <div class="substep">
                <h4>2.3: Set Up OAuth Consent Screen</h4>
                <ol>
                    <li>In the left navigation menu, go to "APIs & Services" > "OAuth consent screen"</li>
                    <li>Select "External" as the user type (unless you have Google Workspace)</li>
                    <li>Click "Create"</li>
                    <li>Fill in the required information:
                        <ul>
                            <li>App name: "NovelEngine Analytics"</li>
                            <li>User support email: Your email address</li>
                            <li>Developer contact information: Your email address</li>
                        </ul>
                    </li>
                    <li>Click "Save and Continue"</li>
                    <li>On the "Scopes" page, click "Save and Continue" (we'll add scopes later)</li>
                    <li>On the "Test users" page, click "Save and Continue"</li>
                    <li>Review your settings and click "Back to Dashboard"</li>
                </ol>
                
                <div class="warning">
                    For production use, you may need to verify your app with Google. For personal or internal use, you can leave it in "Testing" mode, which allows up to 100 users.
                </div>
            </div>
        </div>
        
        <!-- Step 3: OAuth Credentials -->
        <div class="content-section" id="step3">
            <h2 class="step-title">
                <div class="step-icon">🔑</div>
                Step 3: Create OAuth Credentials
            </h2>
            
            <div class="substep">
                <h4>3.1: Create OAuth Client ID</h4>
                <ol>
                    <li>In the Google Cloud Console, go to "APIs & Services" > "Credentials"</li>
                    <li>Click the "Create Credentials" button and select "OAuth client ID"</li>
                    <li>For Application type, select "Web application"</li>
                    <li>Enter a name for your OAuth client (e.g., "NovelEngine Web Client")</li>
                    <li>Under "Authorized JavaScript origins", add your website's URL:
                        <div class="code-snippet"><?php echo APP_URL; ?></div>
                    </li>
                    <li>Under "Authorized redirect URIs", add your callback URL:
                        <div class="code-snippet"><?php echo GOOGLE_REDIRECT_URI?></div>
                    </li>
                    <li>Click "Create"</li>
                </ol>
                
                <div class="image-container">
                    <img src="<?php echo APP_URL.'/plugins/google-analytics/views/screenshot/4.png'?>" alt="Creating OAuth Client ID" class="screenshot">
                    <p class="image-caption">Creating OAuth client credentials</p>
                </div>
            </div>
            
            <div class="substep">
                <h4>3.2: Save Your Credentials</h4>
                <p>After creating the OAuth client, you'll see a popup with your credentials:</p>
                
                <div class="highlight-box">
                    <h4>Your OAuth Credentials</h4>
                    <p><strong>Client ID:</strong> [Your client ID will appear here]</p>
                    <p><strong>Client Secret:</strong> [Your client secret will appear here]</p>
                </div>
                
                <div class="warning">
                    <strong>Important:</strong> Save these credentials immediately! You'll need them to configure the NovelEngine plugin. The client secret will not be shown again.
                </div>
                
                <p>Click "OK" after saving your credentials.</p>
            </div>
        </div>
        
        <!-- Step 4: Enable APIs -->
        <div class="content-section" id="step4">
            <h2 class="step-title">
                <div class="step-icon">📚</div>
                Step 4: Enable Required APIs
            </h2>
            
            <div class="substep">
                <h4>4.1: Access API Library</h4>
                <ol>
                    <li>In the Google Cloud Console, go to "APIs & Services" > "Library"</li>
                </ol>
            </div>
            
            <div class="substep">
                <h4>4.2: Enable Google Analytics APIs</h4>
                <p>You need to enable three specific APIs for the NovelEngine plugin to work correctly:</p>
                
                <ol>
                    <li><strong>Google Analytics API</strong>
                        <ul>
                            <li>Search for "Google Analytics API"</li>
                            <li>Click on the result</li>
                            <li>Click "Enable"</li>
                        </ul>
                    </li>
                    <li><strong>Google Analytics Data API (GA4)</strong>
                        <ul>
                            <li>Search for "Google Analytics Data API"</li>
                            <li>Click on the result</li>
                            <li>Click "Enable"</li>
                        </ul>
                    </li>
                    <li><strong>Google Analytics Admin API</strong>
                        <ul>
                            <li>Search for "Google Analytics Admin API"</li>
                            <li>Click on the result</li>
                            <li>Click "Enable"</li>
                        </ul>
                    </li>
                </ol>
                
                <div class="image-container">
                    <img src="<?php echo APP_URL.'/plugins/google-analytics/views/screenshot/5.png'?>" alt="Enabling Google APIs" class="screenshot">
                    <p class="image-caption">Enabling required Google APIs</p>
                </div>
                
                <div class="success">
                    After enabling all three APIs, your NovelEngine plugin will have all the necessary permissions to access Google Analytics data.
                </div>
            </div>
        </div>
        
        <!-- Step 5: Configure Plugin -->
        <div class="content-section" id="step5">
            <h2 class="step-title">
                <div class="step-icon">🔄</div>
                Step 5: Configure NovelEngine Plugin
            </h2>
            
            <div class="substep">
                <h4>5.1: Gather Your Information</h4>
                <p>Before configuring the plugin in NovelEngine V2.0, make sure you have:</p>
                
                <div class="highlight-box">
                    <h4>Required Information</h4>
                    <ul>
                        <li><strong>OAuth Client ID:</strong> From Google Cloud Console</li>
                        <li><strong>OAuth Client Secret:</strong> From Google Cloud Console</li>
                        <li><strong>Redirect URI:</strong> <?php echo GOOGLE_REDIRECT_URI?></li>
                    </ul>
                </div>
            </div>
            
            <div class="substep">
                <h4>5.2: Enter Credentials in NovelEngine</h4>
                <ol>
                    <li>Log in to your NovelEngine V2.0 admin panel</li>
                    <li>Navigate to <a href="<?php echo $pluginURL.'&route=connect'?>">Google analytic plugin page</a></li>
                    
                    <li>Enter your OAuth Client ID</li>
                    <li>Enter your OAuth Client Secret</li>
                    <li>Verify the Redirect URI matches what you configured in Google Cloud Console</li>
                    <li>Save your settings</li>
                </ol>
                
                <div class="success">
                    After saving your settings, the plugin will be ready to connect to Google Analytics.
                </div>
            </div>
            
            <div class="substep">
                <h4>5.3: Connect to Google Analytics</h4>
                <ol>
                    <li>In the NovelEngine admin panel, go to <a href="<?php echo $pluginURL.'&route=connect'?>">Connection Page</a> > and click "Connect"</li>
                    <li>Click the "Connect to Google Analytics" button</li>
                    <li>You'll be redirected to Google's authorization page</li>
                    <li>Select your Google account and grant the requested permissions</li>
                    <li>After authorization, you'll be redirected back to NovelEngine</li>
                    <li>Select the Google Analytics property you want to use</li>
                    <li>Click "Save" to complete the connection</li>
                </ol>
                
                <div class="success">
                    Congratulations! Your NovelEngine V2.0 is now connected to Google Analytics. You can now view analytics data directly in your admin panel.
                </div>
            </div>
        </div>
        
        <!-- Troubleshooting -->
        <div class="content-section">
            <h2 class="step-title">
                <div class="step-icon">🔍</div>
                Troubleshooting Common Issues
            </h2>
            
            <div class="substep">
                <h4>OAuth Errors</h4>
                <div class="warning">
                    <strong>Error:</strong> "redirect_uri_mismatch"
                    <br><strong>Solution:</strong> Ensure the redirect URI in Google Cloud Console exactly matches your callback URL in NovelEngine.
                </div>
                
                <div class="warning">
                    <strong>Error:</strong> "invalid_client"
                    <br><strong>Solution:</strong> Double-check your Client ID and Client Secret in the NovelEngine plugin settings.
                </div>
            </div>
            
            <div class="substep">
                <h4>No Data Showing</h4>
                <div class="warning">
                    <strong>Problem:</strong> Analytics dashboard shows zeros for all metrics
                    <br><strong>Solutions:</strong>
                    <ul>
                        <li>Verify your website has Google Analytics tracking installed</li>
                        <li>Check if you're using GA4 vs Universal Analytics</li>
                        <li>Ensure the selected property has recent data</li>
                        <li>Try a longer date range</li>
                    </ul>
                </div>
            </div>
        </div>
        
        <!-- Navigation -->
        <div class="navigation">
            <a href="#" onclick="window.print()" class="button">Print Guide</a>
            <a href="mailto:shuraihusman@gmail.com" class="button">Get Support</a>
        </div>
        
        <!-- Footer -->
        <div style="text-align: center; padding: 30px 20px; color: #6c757d; border-top: 1px solid #eee; margin-top: 30px;">
            <p><strong>NovelEngine V2.0</strong> - Google Analytics Integration Plugin</p>
            <p>This guide is for the official Google Analytics plugin for NovelEngine V2.0</p>
          
        </div>
    </div>
