<?php

require_once ROOTH . '/Template/admin/header.php';

$current_route = isset($_GET['route']) ? $_GET['route'] : 'connect';

// Define navigation items
$nav_items = [
    'connect' => [
        'title' => 'Config / Connect',
        'icon' => 'bi-link-45deg',
        'description' => 'Configure and connect to Google Analytics'
    ],
    'dashboard' => [
        'title' => 'Dashboard',
        'icon' => 'bi-speedometer2',
        'description' => 'View analytics overview and charts'
    ],
    'all' => [
        'title' => 'All Statistics',
        'icon' => 'bi-bar-chart-line',
        'description' => 'Detailed analytics with pagination and filters'
    ],
    'how-to' => [
        'title' => 'How to Installed and Set',
        'icon' => 'bi-question-circle',
        'description' => 'Setup guide for Google Analytics integration'
    ],

    [
        'select-property' => [
            'title' => 'Select Property',
            'icon' => 'bi-tick',
            'description' => 'Select Google Analytic property'
        ]
    ]
];

// Function to check if route is active
function isActive($route, $current)
{
    return $route === $current ? 'active' : '';
}

// Function to build URL with route parameter
function buildUrl($route)
{
    global $pluginURL;
    return $pluginURL . '&route=' . $route;
}
?>


<!-- Main Container -->
<div class="container-fluid">
    <div class="row">

        <!-- Main Content Area -->
        <div class="col-md-12">

            <!-- Top Navigation Bar -->
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2 text-primary">
                    <i class="<?php echo $nav_items[$current_route]['icon']; ?> me-2"></i>
                    <?php echo htmlspecialchars($nav_items[$current_route]['title']); ?>
                </h1>

                <!-- Breadcrumb -->
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item">
                            <a href="#" class="text-decoration-none"><?php echo APP_NAME; ?></a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="#" class="text-decoration-none">Plugins</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Google Analytics
                        </li>
                    </ol>
                </nav>
            </div>

            <!-- Quick Actions Bar -->
            <div class="row mb-4">
                <div class="col-12">
                    <div class="card border-0 shadow-sm">
                        <div class="card-body py-3">
                            <div class="d-flex flex-wrap justify-content-between align-items-center">

                                <!-- Quick Navigation Pills -->
                                <div class="d-flex flex-wrap gap-2 mb-2 mb-md-0">
                                    <?php foreach ($nav_items as $route => $item): ?>
                                        <a href="<?php echo $pluginURL . '&route=' . $route; ?>"
                                            class="btn btn-sm <?php echo $current_route === $route ? 'btn-primary' : 'btn-outline-secondary'; ?>">
                                            <i class="<?php echo $item['icon']; ?> me-1"></i>
                                            <span class="d-none d-sm-inline"><?php echo htmlspecialchars($item['title']); ?></span>
                                        </a>
                                    <?php endforeach; ?>
                                </div>

                                <!-- Action Buttons -->
                                <div class="d-flex gap-2">
                                    <button type="button" class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#helpModal">
                                        <i class="bi bi-question-circle me-1"></i>
                                        Help
                                    </button>
                                    <div class="dropdown">
                                        <button class="btn btn-outline-secondary btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                            <i class="bi bi-gear me-1"></i>
                                            Settings
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li><a class="dropdown-item" href="<?php echo $pluginURL . '&route=connect'; ?>">
                                                    <i class="bi bi-link-45deg me-2"></i>Connection Settings
                                                </a></li>
                                            <li><a class="dropdown-item" href="<?php echo $pluginURL . '&route=how-to'; ?>">
                                                    <i class="bi bi-book me-2"></i>Setup Guide
                                                </a></li>
                                            <li>
                                                <hr class="dropdown-divider">
                                            </li>
                                            <li><a class="dropdown-item text-danger" href="#" onclick="return confirm('Are you sure you want to disconnect?')">
                                                    <i class="bi bi-x-circle me-2"></i>Disconnect
                                                </a></li>
                                        </ul>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Page Content -->
            <div class="row">
                <div class="col-12">