 <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            margin: 0;
            padding: 20px;
            background: #f5f5f5;
        }
        .container {
            margin: 0 auto;
            background: white;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 1px solid #eee;
        }
        .filters {
            display: flex;
            gap: 15px;
            margin-bottom: 20px;
            flex-wrap: wrap;
            align-items: center;
        }
        .filter-group {
            display: flex;
            flex-direction: column;
            gap: 5px;
        }
        .filter-group label {
            font-size: 12px;
            color: #666;
            font-weight: bold;
        }
        select, input {
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
        }
        .button {
            background: #9055fd;
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 4px;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            font-size: 14px;
        }
        .button:hover {
            background: #804be0;
            color: white;
        }
        .button.secondary {
            background: #6c757d;
        }
        .data-tabs {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
            border-bottom: 1px solid #eee;
        }
        .tab {
            padding: 10px 15px;
            background: #f8f9fa;
            border: 1px solid #ddd;
            border-bottom: none;
            border-radius: 5px 5px 0 0;
            text-decoration: none;
            color: #666;
        }
        .tab.active {
            background: white;
            color: #9055fd;
            font-weight: bold;
        }
        .data-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        .data-table th, .data-table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #eee;
        }
        .data-table th {
            background: #f8f9fa;
            font-weight: bold;
            position: sticky;
            top: 0;
        }
        .data-table tr:hover {
            background: #f8f9fa;
        }
        .pagination {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 20px;
            padding-top: 15px;
            border-top: 1px solid #eee;
        }
        .pagination-info {
            color: #666;
            font-size: 14px;
        }
        .pagination-controls {
            display: flex;
            gap: 10px;
            align-items: center;
        }
        .page-input {
            width: 60px;
            text-align: center;
        }
        .stats-summary {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 20px;
        }
        .stat-card {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            text-align: center;
        }
        .stat-value {
            font-size: 24px;
            font-weight: bold;
            color: #9055fd;
        }
        .stat-label {
            font-size: 12px;
            color: #666;
            margin-top: 5px;
        }
        .error-message {
            background: #f8d7da;
            color: #721c24;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            border: 1px solid #f5c6cb;
        }
        .custom-date-range {
            display: none;
            gap: 10px;
            align-items: center;
        }
        .custom-date-range.show {
            display: flex;
        }
        @media (max-width: 768px) {
            .filters {
                flex-direction: column;
                align-items: stretch;
            }
            .header {
                flex-direction: column;
                align-items: stretch;
                gap: 15px;
            }
            .data-tabs {
                flex-wrap: wrap;
            }
            .pagination {
                flex-direction: column;
                gap: 15px;
            }
        }
    </style>

    <div class="container-xxl flex-grow-1 container-p-y container">
        <div class="header">
            <div>
                <h1>Analytics Details</h1>
                <p>Property: <?php echo htmlspecialchars($credentials['property_name']); ?></p>
            </div>
            <div>
                <a href="<?php echo $pluginURL.'&route=dashboard'; ?>" class="button secondary">Back to Dashboard</a>
            </div>
        </div>
        
        <?php if (isset($error)): ?>
            <div class="error-message">
                <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>
        
        <!-- Data Type Tabs -->
        <div class="data-tabs">
            <a href="setting?plugin=google-analytics&route=all&type=countries&filter=<?php echo $filter; ?>&page=1" 
               class="tab <?php echo $data_type === 'countries' ? 'active' : ''; ?>">
                Views by Country
            </a>
            <a href="setting?plugin=google-analytics&route=all&type=pages&filter=<?php echo $filter; ?>&page=1" 
               class="tab <?php echo $data_type === 'pages' ? 'active' : ''; ?>">
                Views by Page
            </a>
            <a href="setting?plugin=google-analytics&route=all&type=referrers&filter=<?php echo $filter; ?>&page=1" 
               class="tab <?php echo $data_type === 'referrers' ? 'active' : ''; ?>">
                Referrers
            </a>
            <a href="setting?plugin=google-analytics&route=all&type=sessions&filter=<?php echo $filter; ?>&page=1" 
               class="tab <?php echo $data_type === 'sessions' ? 'active' : ''; ?>">
                Sessions
            </a>
        </div>
        
        <!-- Filters -->
        <form method="get" action="" class="filters">
            <input type="hidden" name="plugin" value="google-analytics">
            <input type="hidden" name="route" value="all">
            <input type="hidden" name="type" value="<?php echo htmlspecialchars($data_type); ?>">
            
            <div class="filter-group">
                <label>Time Period</label>
                <select name="filter" id="filterSelect" onchange="toggleCustomDate()">
                    <option value="today" <?php echo $filter === 'today' ? 'selected' : ''; ?>>Today</option>
                    <option value="this_week" <?php echo $filter === 'this_week' ? 'selected' : ''; ?>>This Week</option>
                    <option value="this_month" <?php echo $filter === 'this_month' ? 'selected' : ''; ?>>This Month</option>
                    <option value="this_year" <?php echo $filter === 'this_year' ? 'selected' : ''; ?>>This Year</option>
                    <option value="last_7_days" <?php echo $filter === 'last_7_days' ? 'selected' : ''; ?>>Last 7 Days</option>
                    <option value="last_30_days" <?php echo $filter === 'last_30_days' ? 'selected' : ''; ?>>Last 30 Days</option>
                    <option value="last_90_days" <?php echo $filter === 'last_90_days' ? 'selected' : ''; ?>>Last 90 Days</option>
                    <option value="custom" <?php echo $filter === 'custom' ? 'selected' : ''; ?>>Custom Range</option>
                </select>
            </div>
            
            <div class="custom-date-range <?php echo $filter === 'custom' ? 'show' : ''; ?>" id="customDateRange">
                <div class="filter-group">
                    <label>Start Date</label>
                    <input type="date" name="custom_start" value="<?php echo htmlspecialchars($custom_start); ?>">
                </div>
                <div class="filter-group">
                    <label>End Date</label>
                    <input type="date" name="custom_end" value="<?php echo htmlspecialchars($custom_end); ?>">
                </div>
            </div>
            
            <div class="filter-group">
                <label>Items per Page</label>
                <select name="limit">
                    <option value="10" <?php echo $limit === 10 ? 'selected' : ''; ?>>10</option>
                    <option value="25" <?php echo $limit === 25 ? 'selected' : ''; ?>>25</option>
                    <option value="50" <?php echo $limit === 50 ? 'selected' : ''; ?>>50</option>
                    <option value="100" <?php echo $limit === 100 ? 'selected' : ''; ?>>100</option>
                </select>
            </div>
            
            <div class="filter-group">
                <label>&nbsp;</label>
                <button type="submit" class="button">Apply Filters</button>
            </div>
        </form>
        
        <!-- Summary Stats -->
        <?php if (!empty($data)): ?>
            <div class="stats-summary">
                <div class="stat-card">
                    <div class="stat-value"><?php echo number_format($total_items); ?></div>
                    <div class="stat-label">Total Items</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value"><?php echo $start_date; ?></div>
                    <div class="stat-label">Start Date</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value"><?php echo $end_date; ?></div>
                    <div class="stat-label">End Date</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value"><?php echo $total_pages; ?></div>
                    <div class="stat-label">Total Pages</div>
                </div>
            </div>
        <?php endif; ?>
        
        <!-- Data Table -->
        <?php if (!empty($paginated_data)): ?>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>#</th>
                        <?php if ($data_type === 'countries'): ?>
                            <th>Country</th>
                            <th>Users</th>
                            <th>Sessions</th>
                            <th>Percentage</th>
                        <?php elseif ($data_type === 'pages'): ?>
                            <th>Page Path</th>
                            <th>Page Views</th>
                            <th>Unique Views</th>
                            <th>Percentage</th>
                        <?php elseif ($data_type === 'referrers'): ?>
                            <th>Source</th>
                            <th>Sessions</th>
                            <th>Users</th>
                            <th>Percentage</th>
                        <?php elseif ($data_type === 'sessions'): ?>
                            <th>Date</th>
                            <th>Sessions</th>
                            <th>Users</th>
                            <th>Bounce Rate</th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $total_value = array_sum(array_column($data, $data_type === 'countries' ? 'users' : ($data_type === 'pages' ? 'pageviews' : 'sessions')));
                    foreach ($paginated_data as $index => $item): 
                        $row_number = $offset + $index + 1;
                    ?>
                        <tr>
                            <td><?php echo $row_number; ?></td>
                            <?php if ($data_type === 'countries'): ?>
                                <td><?php echo htmlspecialchars($item['country']); ?></td>
                                <td><?php echo number_format($item['users']); ?></td>
                                <td><?php echo number_format($item['sessions'] ?? 0); ?></td>
                                <td><?php echo $total_value > 0 ? number_format(($item['users'] / $total_value) * 100, 1) : 0; ?>%</td>
                            <?php elseif ($data_type === 'pages'): ?>
                                <td><?php echo htmlspecialchars($item['pagePath']); ?></td>
                                <td><?php echo number_format($item['pageviews']); ?></td>
                                <td><?php echo number_format($item['uniquePageviews'] ?? $item['pageviews']); ?></td>
                                <td><?php echo $total_value > 0 ? number_format(($item['pageviews'] / $total_value) * 100, 1) : 0; ?>%</td>
                            <?php elseif ($data_type === 'referrers'): ?>
                                <td><?php echo htmlspecialchars($item['source']); ?></td>
                                <td><?php echo number_format($item['sessions']); ?></td>
                                <td><?php echo number_format($item['users'] ?? 0); ?></td>
                                <td><?php echo $total_value > 0 ? number_format(($item['sessions'] / $total_value) * 100, 1) : 0; ?>%</td>
                            <?php elseif ($data_type === 'sessions'): ?>
                                <td><?php echo htmlspecialchars($item['date']); ?></td>
                                <td><?php echo number_format($item['sessions']); ?></td>
                                <td><?php echo number_format($item['users']); ?></td>
                                <td><?php echo number_format($item['bounceRate'] ?? 0, 1); ?>%</td>
                            <?php endif; ?>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            
            <!-- Pagination -->
            <div class="pagination">
                <div class="pagination-info">
                    Showing <?php echo number_format($start_item); ?> to <?php echo number_format($end_item); ?> 
                    of <?php echo number_format($total_items); ?> items
                </div>
                
                <div class="pagination-controls">
                        <?php if ($page > 1): ?>
                            <a class="button" href="?<?php echo buildQueryString(['page' => 1]); ?>">First</a>
                            <a class="button" href="?<?php echo buildQueryString(['page' => $page - 1]); ?>">Previous</a>
                        <?php endif; ?>
                    
                    <form method="get" action="" style="display: inline-flex; align-items: center; gap: 5px;">
                        <input type="hidden" name="plugin" value="google-analytics" />
                        <input type="hidden" name="route" value="all" />
                        <input type="hidden" name="type" value="<?php echo htmlspecialchars($data_type); ?>">
                        <input type="hidden" name="filter" value="<?php echo htmlspecialchars($filter); ?>">
                        <input type="hidden" name="limit" value="<?php echo $limit; ?>">
                        <?php if ($filter === 'custom'): ?>
                            <input type="hidden" name="custom_start" value="<?php echo htmlspecialchars($custom_start); ?>">
                            <input type="hidden" name="custom_end" value="<?php echo htmlspecialchars($custom_end); ?>">
                        <?php endif; ?>
                        <span>Page</span>
                        <input type="number" name="page" value="<?php echo $page; ?>" min="1" max="<?php echo $total_pages; ?>" class="page-input">
                        <span>of <?php echo $total_pages; ?></span>
                        <button type="submit" class="button">Go</button>
                    </form>
                    

                        <?php if ($page < $total_pages): ?>
                            <a class="button" href="?<?php echo buildQueryString(['page' => $page + 1]); ?>">Next</a>
                            <a class="button" href="?<?php echo buildQueryString(['page' => $total_pages]); ?>">Last</a>
                        <?php endif; ?>
                </div>
            </div>
        <?php else: ?>
            <div style="text-align: center; padding: 40px; color: #666;">
                <h3>No data available</h3>
                <p>No <?php echo str_replace('_', ' ', $data_type); ?> data found for the selected time period.</p>
                <p>Try selecting a different time range or check if your tracking code is properly installed.</p>
            </div>
        <?php endif; ?>
    </div>
    
    <script>
        function toggleCustomDate() {
            const filterSelect = document.getElementById('filterSelect');
            const customDateRange = document.getElementById('customDateRange');
            
            if (filterSelect.value === 'custom') {
                customDateRange.classList.add('show');
            } else {
                customDateRange.classList.remove('show');
            }
        }
        
        // Initialize on page load
        toggleCustomDate();
    </script>