<?php
$user_id = $_SESSION['adminID'] ?? null;

// Get Google Analytics credentials from database
$credentials = $db->table('google_analytics_credentials')->where('status', 1)->first();

if (!$credentials) {
    Redirect($pluginURL.'&route=connect');
    exit;
}

// Pagination settings
$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$limit = isset($_GET['limit']) ? max(10, min(100, (int)$_GET['limit'])) : 25;
$offset = ($page - 1) * $limit;

// Filter settings
$filter = isset($_GET['filter']) ? $_GET['filter'] : 'this_month';
$data_type = isset($_GET['type']) ? $_GET['type'] : 'countries';

// Custom date range
$custom_start = isset($_GET['custom_start']) ? $_GET['custom_start'] : '';
$custom_end = isset($_GET['custom_end']) ? $_GET['custom_end'] : '';

// Calculate date ranges based on filter
function getDateRange($filter, $custom_start = '', $custom_end = '') {
    $end_date = date('Y-m-d');
    
    switch ($filter) {
        case 'today':
            $start_date = date('Y-m-d');
            break;
        case 'this_week':
            $start_date = date('Y-m-d', strtotime('monday this week'));
            break;
        case 'this_month':
            $start_date = date('Y-m-01');
            break;
        case 'this_year':
            $start_date = date('Y-01-01');
            break;
        case 'last_7_days':
            $start_date = date('Y-m-d', strtotime('-7 days'));
            break;
        case 'last_30_days':
            $start_date = date('Y-m-d', strtotime('-30 days'));
            break;
        case 'last_90_days':
            $start_date = date('Y-m-d', strtotime('-90 days'));
            break;
        case 'custom':
            $start_date = $custom_start ?: date('Y-m-d', strtotime('-30 days'));
            $end_date = $custom_end ?: date('Y-m-d');
            break;
        default:
            $start_date = date('Y-m-01');
    }
    
    return [$start_date, $end_date];
}

list($start_date, $end_date) = getDateRange($filter, $custom_start, $custom_end);

try {
    // Create analytics service
    $analyticsService = new GoogleAnalyticsService($credentials);
    
    // Get data based on type
    $data = [];
    $total_items = 0;
    
    switch ($data_type) {
        case 'countries':
            $data = $analyticsService->getUserCountries($start_date, $end_date, 1000); // Get more data for pagination
            break;
        case 'pages':
            $data = $analyticsService->getPageViews($start_date, $end_date, 1000);
            break;
        case 'referrers':
            $data = $analyticsService->getReferrers($start_date, $end_date, 1000);
            break;
        case 'sessions':
            $data = $analyticsService->getSessionData($start_date, $end_date, 1000);
            break;
    }
    
    $total_items = count($data);
    
    // Apply pagination
    $paginated_data = array_slice($data, $offset, $limit);
    
} catch (Exception $e) {
    $error = "Error loading analytics data: " . $e->getMessage();
    error_log($error);
    $data = [];
    $paginated_data = [];
    $total_items = 0;
}

// Calculate pagination info
$total_pages = ceil($total_items / $limit);
$start_item = $offset + 1;
$end_item = min($offset + $limit, $total_items);


require_once($headerT);
require_once $pvt.'/details.php';
require_once($footerT);
?>