<?php
$auts = $db->table('ebook e')
        ->leftJoin('category c', 'e.cid', '=', 'c.id')
        ->select('e.*, c.name as cat_title, c.slug as cat_slug')
        ->where('e.status', 1)
        ->search(['e.author'], $file['author'])
        ->limit('8')
        ->get();

?>





<div class="row">
        <?php foreach ($auts as $item) : ?>
            <?php

            $image = empty($item['image']) ? APP_URL . '/Public/assets/main/img/noimg.jpg' : APP_URL . '/Public/thumb/182x268' . $item['img_folder'] . '/' . $item['image'];

            ?>
            <!-- item -->
            <div class="col-6 col-sm-4 col-lg-3">
                <div class="item">
                    <div class="item__cover">
                        <img src="<?php echo  $image; ?>" alt="<?php echo $item['name'] ?>">
                        <a href="<?php echo APP_URL . '/' . $item['slug']; ?>" class="item__play">
                            <i class="ti ti-book"></i>
                        </a>
                    </div>
                    <div class="item__content">
                    <h3 class="item__title"><a href="<?php echo APP_URL . '/' . $item['slug']; ?>" style="width:200px"><?php echo $item['name'] ?></a></h3>
                        <span class="item__category">
                            <a href="<?php echo APP_URL . '/category/' . $item['cat_slug']; ?>"><?php echo $item['cat_title']?></a>
                        </span>
                    </div>
                </div>
            </div>

            

        <?php endforeach; ?>
</div>