<?php
global $currentURL, $db;
global $lang, $isLogin, $AuthUser;
$gen = new App\General\All();
$footCat = $gen->getList('category', 'id', 5);
$pages = $gen->getList('page', 'id', 5);
$blog_header_cat = $db->table('cats')->orderBy('id')->limit(5)->get();

?>
<html lang="en">

<head>

  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <?php echo getMetaCode('head'); ?>

  <!--Google Font-->
  <link rel="stylesheet" href='http://fonts.googleapis.com/css?family=Dosis:400,700,500|Nunito:300,400,600' />
  <!-- Mobile specific meta -->
  <meta name=viewport content="width=device-width, initial-scale=1">
  <meta name="format-detection" content="telephone-no">

  <!-- CSS files -->
  <link rel="stylesheet" href="<?= MAIN_ASSETS ?>/css/bootstrap.min.css">
  <link rel="stylesheet" href="<?= MAIN_ASSETS ?>/css/splide.min.css">
  <link rel="stylesheet" href="<?= MAIN_ASSETS ?>/css/slimselect.css">
  <link rel="stylesheet" href="<?= MAIN_ASSETS ?>/css/plyr.css">
  <link rel="stylesheet" href="<?= MAIN_ASSETS ?>/css/photoswipe.css">
  <link rel="stylesheet" href="<?= MAIN_ASSETS ?>/css/default-skin.css">
  <link rel="stylesheet" href="<?= MAIN_ASSETS ?>/css/main.css">

  <!-- Icon font -->
  <link rel="stylesheet" href="<?= MAIN_ASSETS ?>/webfont/tabler-icons.min.css">

  <link rel="apple-touch-icon" sizes="180x180" href="<?= APP_URL ?>/Public/favicon/apple-touch-icon.png">
  <link rel="icon" type="image/png" sizes="32x32" href="<?= APP_URL ?>/Public/favicon/favicon-32x32.png">
  <link rel="icon" type="image/png" sizes="16x16" href="<?= APP_URL ?>/Public/favicon/favicon-16x16.png">
  <link rel="manifest" href="<?= APP_URL ?>/Public/favicon/site.webmanifest">

  <link rel="manifest" href="<?= APP_URL ?>/Public/fav/manifest.json">

  <title><?php echo isset($title) ? $title . ' ' . APP_NAME : APP_NAME; ?></title>
  <link rel="canonical" href="<?php echo $currentURL ?>">
  <?php if (isset($schema)): ?>
    <script type="application/ld+json">
      <?php echo json_encode($schema); ?>
    </script>
  <?php endif; ?>
  <meta name="language" content="en">
  <meta name="theme-color" content="#0f2133">
  <!-- Webmaster Seo Tag -->
  <meta name="title" content="<?php echo $title; ?>">
  <?php if (isset($metadescription)): ?>
    <meta name="description" content="<?php echo $metadescription; ?>">
  <?php else: ?>
    <meta property="description" content="<?php echo $lang['SITE_DESCRIPTION']; ?>">
  <?php endif; ?>
  <?php if (isset($metakeyword)): ?>
    <meta name="keywords" content="<?php echo $metakeyword; ?>">
  <?php else: ?>
    <meta property="keywords" content="<?php echo $lang['SITE_KEYWORDS'];; ?>">
  <?php endif; ?>
  <?php (isset($metanofollow) && $metanofollow == true) ? '<meta name="robots" content="noindex, nofollow">  ' : ''; ?>

  <!-- Open Graph Meta Tag -->
  <meta property="og:url" content="<?php echo $currentURL; ?>">
  <meta property="og:type" content="article">
  <meta property="og:title" content="<?php echo $title; ?>">
  <?php if (isset($metadescription)): ?>
    <meta property="og:description" content="<?php echo $metadescription; ?>">
  <?php else: ?>
    <meta property="og:description" content="<?php echo $lang['SITE_DESCRIPTION']; ?>">
  <?php endif; ?>
  <?php if (isset($metakeyword)): ?>
    <meta property="og:keywords" content="<?php echo $metakeyword; ?>">
  <?php else: ?>
    <meta property="og:keywords" content="<?php echo $lang['SITE_KEYWORDS'];; ?>">
  <?php endif; ?>
  <?php if (isset($ogImage)): ?>
    <meta property="og:image" content="<?php echo $ogImage; ?>">
  <?php else: ?>
    <meta property="og:image" content="<?php echo LOGO_URL; ?>">
  <?php endif; ?>

  <style>
    .float {
      position: fixed;
      width: 60px;
      height: 60px;
      bottom: 40px;
      right: 40px;
      background-color: #25d366;
      color: #FFF;
      border-radius: 50px;
      text-align: center;
      font-size: 30px;
      box-shadow: 2px 2px 3px #999;
      z-index: 100;
    }

    .my-float {
      margin-top: 16px;
    }

    .telegram-float {
      position: fixed;
      bottom: 40px;
      left: 40px;
      z-index: 1000;
    }

    .telegram-icon {
      width: 60px;
      height: 60px;
      border-radius: 50%;
      background-color: #0088cc;
      display: flex;
      justify-content: center;
      align-items: center;
      animation-name: pulse;
      animation-duration: 1.5s;
      animation-timing-function: ease-out;
      animation-iteration-count: infinite;
    }

    @keyframes pulse {
      0% {
        box-shadow: 0 0 0 0 rgba(0, 136, 204, 0.5);
      }

      80% {
        box-shadow: 0 0 0 14px rgba(0, 136, 204, 0);
      }
    }

    .telegram-icon svg {
      fill: #fff;
      width: 30px;
      height: 30px;
    }

    .swing:hover {
  -webkit-transform-origin: top center;
  -ms-transform-origin: top center;
  transform-origin: top center;
  -webkit-animation-name: swing;
  animation-name: swing;
  -webkit-animation-duration: 1s;
  animation-duration: 1s;
  -webkit-animation-fill-mode: both;
  animation-fill-mode: both;
  }
  @-webkit-keyframes swing {
  20% {
  -webkit-transform: rotate3d(0, 0, 1, 15deg);
  transform: rotate3d(0, 0, 1, 15deg);
  }
  40% {
  -webkit-transform: rotate3d(0, 0, 1, -10deg);
  transform: rotate3d(0, 0, 1, -10deg);
  }
  60% {
  -webkit-transform: rotate3d(0, 0, 1, 5deg);
  transform: rotate3d(0, 0, 1, 5deg);
  }
  80% {
  -webkit-transform: rotate3d(0, 0, 1, -5deg);
  transform: rotate3d(0, 0, 1, -5deg);
  }
  100% {
  -webkit-transform: rotate3d(0, 0, 1, 0deg);
  transform: rotate3d(0, 0, 1, 0deg);
  }
  }
  @keyframes swing {
  20% {
  -webkit-transform: rotate3d(0, 0, 1, 15deg);
  transform: rotate3d(0, 0, 1, 15deg);
  }
  40% {
  -webkit-transform: rotate3d(0, 0, 1, -10deg);
  transform: rotate3d(0, 0, 1, -10deg);
  }
  60% {
  -webkit-transform: rotate3d(0, 0, 1, 5deg);
  transform: rotate3d(0, 0, 1, 5deg);
  }
  80% {
  -webkit-transform: rotate3d(0, 0, 1, -5deg);
  transform: rotate3d(0, 0, 1, -5deg);
  }
  100% {
  -webkit-transform: rotate3d(0, 0, 1, 0deg);
  transform: rotate3d(0, 0, 1, 0deg);
  }
  }

  .overlay2 {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(60, 60, 60, 0.8);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 9999;
}

.overlay2 .spinner-border {
    width: 3rem;
    height: 3rem;
}

.loader21 {
  position: relative;
  width: 100px;
  height: 100px;
}

.loader21:before , .loader21:after{
  content: '';
  border-radius: 50%;
  position: absolute;
  inset: 0;
  box-shadow: 0 0 10px 2px rgba(0, 0, 0, 0.3) inset;
}
.loader21:after {
  box-shadow: 0 2px 0 #f9ab00 inset;
  animation: rotate 2s linear infinite;
}

@keyframes rotate {
  0% {  transform: rotate(0)}
  100% { transform: rotate(360deg)}
}
  </style>


</head>

<body>
  <div id="overlay2" class="" style="display: none;">
    <span class="loader21"></span>
  </div>



  <!-- header -->
  <header class="header">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <div class="header__content">
            <!-- header logo -->
            <a href="<?php echo APP_URL; ?>" class="header__logo">
              <img src="<?= LOGO_URL ?>" alt="<?php echo APP_NAME; ?>">
            </a>
            <!-- end header logo -->

            <!-- header nav -->
            <ul class="header__nav">
              <!-- dropdown -->
              <li class="header__nav-item">
                <a class="header__nav-link" href="/" role="button">Home</a>
              </li>
              <!-- end dropdown -->

              <!-- dropdown -->
              <li class="header__nav-item">
                <a class="header__nav-link" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">Categories<i class="ti ti-chevron-down"></i></a>

                <ul class="dropdown-menu header__dropdown-menu">
                  <?php foreach ($footCat as $cat): ?>
                    <li><a href="<?php echo APP_URL . '/category/' . $cat['slug']; ?>"><?php echo $cat['name']; ?></a></li>
                  <?php endforeach; ?>
                </ul>
              </li>
              <!-- end dropdown -->

              <li class="header__nav-item">
                <a href="<?php echo APP_URL . '/blog'; ?>" class="header__nav-link">Blog</a>
              </li>

              <!-- dropdown -->
              <li class="header__nav-item">
                <a class="header__nav-link" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">Pages <i class="ti ti-chevron-down"></i></a>

                <ul class="dropdown-menu header__dropdown-menu">
                  <?php foreach ($pages as $cat) {
                    echo '<li><a href="' . APP_URL . '/page/' . $cat['slug'] . '">' . $cat['name'] . '</a></li>';
                  } ?>
                </ul>
              </li>
              <!-- end dropdown -->

              <!-- dropdown -->
              <li class="header__nav-item">
                <a class="header__nav-link header__nav-link--more" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false"><i class="ti ti-dots"></i></a>

                <ul class="dropdown-menu header__dropdown-menu">
                  <li><a href="/ebooks">Ebooks</a></li>
                  <li><a href="/books">Books</a></li>
                  <li><a href="/authors">Authors</a></li>
                  <li><a href="/groups">Associations</a></li>
                  <li><a href="/compilers">Compilers</a></li>
                  <li><a href="/blog">Blog</a></li>
                </ul>
              </li>
              <!-- end dropdown -->
            </ul>
            <!-- end header nav -->

            <!-- header auth -->
            <div class="header__auth">
              <form action="<?php echo APP_URL ?>/search" method="get" class="header__search">
                <div class="filter__items" style="margin-right: 5px;">
                  <select class="filter__select" name="type" id="filter__genre">
                    <option value="novel">Novel</option>
                    <option value="author">Author</option>
                    <option value="book">book</option>
                    <option value="group">Association</option>
                    <option value="compiler">Compiler</option>
                  </select>
                </div>
                <input class="header__search-input" type="text" name="search" placeholder="Search...">
                <button class="header__search-button" type="submit">
                  <i class="ti ti-search"></i>
                </button>
                <button class="header__search-close" type="button">
                  <i class="ti ti-x"></i>
                </button>
              </form>

              <button class="header__search-btn" type="button">
                <i class="ti ti-search"></i>
              </button>

              <!-- dropdown -->

              <!-- end dropdown -->

              <!-- dropdown -->
              <?php if ($isLogin): ?>
                <div class="header__profile">
                  <a class="header__sign-in header__sign-in--user" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="ti ti-user"></i>
                    <span><?php echo $AuthUser['username']; ?></span>
                  </a>

                  <ul class="dropdown-menu dropdown-menu-end header__dropdown-menu header__dropdown-menu--user">
                    <li><a href="<?php echo APP_URL ?>/account"><i class="ti ti-ghost"></i>Profile</a></li>
                    <li><a href="<?php echo APP_URL ?>/account?shu=subscribe"><i class="ti ti-stereo-glasses"></i>Subscription</a></li>
                    <li><a href="<?php echo APP_URL ?>/account?shu=edit"><i class="ti ti-settings"></i>Settings</a></li>
                    <li><a href="<?php echo APP_URL ?>/logout"><i class="ti ti-logout"></i>Logout</a></li>
                  </ul>
                </div>
              <?php endif; ?>

              <?php if (!$isLogin): ?>
                <div class="header__profile">
                  <a class="header__sign-in header__sign-in--user" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="ti ti-login"></i>
                    <span>Login</span>
                  </a>

                  <ul class="dropdown-menu dropdown-menu-end header__dropdown-menu header__dropdown-menu--user">
                    <li><a href="<?php echo APP_URL . '/login'; ?>"><i class="ti ti-login"></i>Login</a></li>
                    <li><a href="<?php echo APP_URL . '/register'; ?>"><i class="ti ti-logout"></i>Register</a></li>
                  </ul>
                </div>

              <?php endif; ?>

              <!-- end dropdown -->
            </div>
            <!-- end header auth -->

            <!-- header menu btn -->
            <button class="header__btn" type="button">
              <span></span>
              <span></span>
              <span></span>
            </button>
            <!-- end header menu btn -->
          </div>
        </div>
      </div>
    </div>
  </header>
  <!-- end header -->






  <div class="ads-container">
    <?php echo getAds('header'); ?>
  </div>



  <a href="<?= TELEGRAM_URL ?>" target="_blank" class="telegram-float">
    <div class="telegram-icon">
      <svg viewBox="0 0 64 64">
        <path d="M56.4,8.2l-51.2,20c-1.7,0.6-1.6,3,0.1,3.5l9.7,2.9c2.1,0.6,3.8,2.2,4.4,4.3l3.8,12.1c0.5,1.6,2.5,2.1,3.7,0.9 l5.2-5.3c0.9-0.9,2.2-1,3.2-0.3l11.5,8.4c1.6,1.2,3.9,0.3,4.3-1.7l8.7-41.8C60.4,9.1,58.4,7.4,56.4,8.2z M50,17.4L29.4,35.6 c-1.1,1-1.9,2.4-2,3.9c-0.2,1.5-2.3,1.7-2.8,0.3l-0.9-3c-0.7-2.2,0.2-4.5,2.1-5.7l23.5-14.6C49.9,16.1,50.5,16.9,50,17.4z"></path>
      </svg>
    </div>
  </a>