	<!-- page title -->
	<section class="section section--first">
	    <div class="container">
	        <div class="row">
	            <div class="col-12">
	                <div class="section__wrap">
	                    <!-- section title -->
	                    <h1 class="section__title section__title--head">My Account</h1>
	                    <!-- end section title -->

	                    <!-- breadcrumbs -->
	                    <ul class="breadcrumbs">
	                        <li class="breadcrumbs__item"><a href="/">Home</a></li>
	                        <li class="breadcrumbs__item breadcrumbs__item--active">Profile</li>
	                    </ul>
	                    <!-- end breadcrumbs -->
	                </div>
	            </div>
	        </div>
	    </div>
	</section>
	<!-- end page title -->


	<!-- content -->
	<div class="content">
	    <!-- profile -->
	    <div class="profile">
	        <div class="container">
	            <div class="row">
	                <div class="col-12">
	                    <div class="profile__content">
	                        <div class="profile__user">
	                            <div class="profile__avatar">
	                                <img src="<?php echo $userImage; ?>" alt="">
	                            </div>
	                            <div class="profile__meta">
	                                <h3><?php echo $AuthUser['name'] ?></h3>
	                                <span>USERNAME: <?php echo $AuthUser['username'] ?></span>
	                            </div>
	                        </div>

	                        <!-- content tabs nav -->
	                        <ul class="nav nav-tabs content__tabs content__tabs--profile" id="content__tabs"
	                            role="tablist">
	                            <li class="nav-item" role="presentation">
	                                <a href="<?php echo APP_URL . '/account' ?>" id="1-tab" class="<?php echo $section === 1 ? 'active' : '' ?>">Profile</a>
	                            </li>

	                            <li class="nav-item" role="presentation">
	                                <a href="<?php echo APP_URL . '/account?shu=subscribe' ?>" id="2-tab" class="<?php echo $section === 2 ? 'active' : '' ?>">Subscribe </a>
	                            </li>

	                            <li class="nav-item" role="presentation">
	                                <a  href="<?php echo APP_URL . '/account?shu=notification' ?>" class="<?php echo $section === 3 ? 'active' : '' ?>">Notifications
	                                    (<?php echo $db->table('notifications')->where('is_read', 0)->where('user_id', $AuthUser['id'])->count(); ?>)
	                                </a>
	                            </li>

	                            <li class="nav-item" role="presentation">
	                                <a href="<?php echo APP_URL . '/account?shu=edit' ?>" class="<?php echo $section === 4 ? 'active' : '' ?>">Settings</a>
	                            </li>
	                        </ul>
	                        <!-- end content tabs nav -->

	                        <!-- logout -->
	                        <a href="/logout" class="profile__logout" type="button">
	                            <i class="ti ti-logout"></i>
	                            <span>Logout</span>
	                        </a>
	                        <!-- end logout -->
	                    </div>
	                </div>
	            </div>
	        </div>
	    </div>
	    <!-- end profile -->

	    <div class="container">
	        <!-- content tabs -->
	        <div class="tab-content">

            <?php if ($section == 1): ?>
                <?php include 'account/index.php'; ?>
            <?php endif; ?>

            <?php if ($section == 2): ?>
                <?php include 'account/subscribe.php'; ?>
            <?php endif; ?>

            <?php if ($section == 3): ?>
                <?php include 'account/notification.php'; ?>
            <?php endif; ?>

            <?php if ($section == 4): ?>
                <?php include 'account/edit.php'; ?>
            <?php endif; ?>

	        </div>
	        <!-- end content tabs -->
	    </div>
	</div>
	<!-- end content -->