<style>
/* Enhanced PDF Viewer Styles - Single Page Mode */
.shu-pdf-viewer-container {
    display: flex;
    flex-direction: column;
    height: 100vh;
    background: #f5f5f5;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    overflow: hidden;
}

/* Top Header - Reduced height */
.shu-pdf-top-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 10px 20px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    z-index: 100;
    min-height: 60px;
}

.shu-pdf-branding h1 {
    margin: 0;
    font-size: 1.5rem;
    font-weight: 600;
    text-shadow: 0 1px 2px rgba(0,0,0,0.2);
}

.shu-pdf-page-info-top {
    display: flex;
    align-items: center;
    gap: 20px;
}

.shu-pdf-page-display {
    display: flex;
    align-items: center;
    gap: 8px;
    background: rgba(255,255,255,0.2);
    padding: 8px 12px;
    border-radius: 20px;
    backdrop-filter: blur(10px);
}

.shu-pdf-page-display input {
    width: 50px;
    padding: 4px 8px;
    border: none;
    border-radius: 4px;
    text-align: center;
    background: rgba(255,255,255,0.9);
    color: #333;
}

.shu-pdf-zoom-display-top {
    background: rgba(255,255,255,0.2);
    padding: 8px 12px;
    border-radius: 20px;
    backdrop-filter: blur(10px);
    font-weight: 500;
}

.shu-pdf-side-panel-toggle {
    background: rgba(255,255,255,0.2);
    border: none;
    color: white;
    padding: 10px;
    border-radius: 50%;
    cursor: pointer;
    transition: all 0.3s ease;
    backdrop-filter: blur(10px);
}

.shu-pdf-side-panel-toggle:hover {
    background: rgba(255,255,255,0.3);
    transform: scale(1.1);
}

/* Main Content */
.shu-pdf-main-content {
    display: flex;
    flex: 1;
    overflow: hidden;
}

/* Side Panel */
.shu-pdf-side-panel {
    width: 250px;
    background: white;
    border-right: 1px solid #e0e0e0;
    transform: translateX(-100%);
    transition: transform 0.3s ease;
    z-index: 50;
    box-shadow: 2px 0 10px rgba(0,0,0,0.1);
}

.shu-pdf-side-panel.open {
    transform: translateX(0);
}

.shu-pdf-side-panel-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 15px 20px;
    border-bottom: 1px solid #e0e0e0;
    background: #f8f9fa;
}

.shu-pdf-side-panel-header h3 {
    margin: 0;
    color: #333;
    font-size: 1.1rem;
}

.shu-pdf-close-panel {
    background: none;
    border: none;
    color: #666;
    cursor: pointer;
    padding: 5px;
    border-radius: 4px;
    transition: all 0.2s ease;
}

.shu-pdf-close-panel:hover {
    background: #e9ecef;
    color: #333;
}

.shu-pdf-page-thumbnails {
    padding: 15px;
    overflow-y: auto;
    height: calc(100vh - 200px);
}

.shu-pdf-thumbnail {
    display: flex;
    align-items: center;
    padding: 10px;
    margin-bottom: 8px;
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.2s ease;
    background: white;
}

.shu-pdf-thumbnail:hover {
    background: #f8f9fa;
    border-color: #667eea;
    transform: translateX(5px);
}

.shu-pdf-thumbnail.active {
    background: #667eea;
    color: white;
    border-color: #667eea;
}

.shu-pdf-thumbnail-canvas {
    width: 40px;
    height: 50px;
    margin-right: 10px;
    border: 1px solid #ddd;
    border-radius: 4px;
}

/* PDF Display Container - Optimized for Single Page */
.shu-pdf-display-container {
    flex: 1;
    position: relative;
    overflow: hidden;
    background: #e9ecef;
    height: calc(100vh - 120px);
}

.shu-pdf-wrapper {
    width: 100%;
    height: 100%;
    position: relative;
    overflow: auto;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 20px;
    cursor: grab;
    touch-action: none;
}

.shu-pdf-wrapper:active {
    cursor: grabbing;
}

.shu-pdf-wrapper.zoomed {
    overflow: auto;
    cursor: move;
}

/* Single Page Layout - Centered and Optimized */
.shu-pdf-pages-container {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    transform-origin: center center;
    position: relative;
    min-height: 100%;
    width: 100%;
}

/* Single Page Container - Optimized for full screen usage */
.shu-pdf-page-container {
    position: relative;
    background: white;
    border-radius: 8px;
    box-shadow: 0 8px 32px rgba(0,0,0,0.12);
    overflow: hidden;
    transition: all 0.3s ease;
    flex-shrink: 0;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    max-width: 95%;
    max-height: 95%;
}

.shu-pdf-page-canvas {
    display: block;
    max-width: 100%;
    max-height: 100%;
    height: auto;
    width: auto;
    transition: none;
}

.shu-pdf-page-branding {
    position: absolute;
    top: 10px;
    left: 50%;
    transform: translateX(-50%);
    background: rgba(102, 126, 234, 0.9);
    color: white;
    padding: 4px 12px;
    border-radius: 12px;
    font-size: 0.8rem;
    font-weight: 500;
    backdrop-filter: blur(10px);
    z-index: 10;
    pointer-events: none;
}

/* Book Flip Animation */
.shu-pdf-page-turning .shu-pdf-page-container {
    animation: bookFlip 0.6s ease-in-out;
}

@keyframes bookFlip {
    0% {
        transform: perspective(1000px) rotateY(0deg);
        opacity: 1;
    }
    50% {
        transform: perspective(1000px) rotateY(-90deg);
        opacity: 0.7;
    }
    100% {
        transform: perspective(1000px) rotateY(0deg);
        opacity: 1;
    }
}

/* Navigation Overlay */
.shu-pdf-nav-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    pointer-events: none;
    z-index: 20;
}

.shu-pdf-nav-arrow {
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    background: rgba(0,0,0,0.7);
    color: white;
    border: none;
    width: 50px;
    height: 50px;
    border-radius: 50%;
    cursor: pointer;
    pointer-events: all;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
}

.shu-pdf-nav-prev {
    left: 20px;
}

.shu-pdf-nav-next {
    right: 20px;
}

.shu-pdf-nav-arrow:hover {
    background: rgba(102, 126, 234, 0.9);
    transform: translateY(-50%) scale(1.1);
}

/* Zoom Controls Overlay */
.shu-pdf-zoom-overlay {
    position: absolute;
    bottom: 80px;
    right: 20px;
    display: flex;
    flex-direction: column;
    gap: 8px;
    z-index: 20;
}

.shu-pdf-zoom-btn {
    background: rgba(0,0,0,0.8);
    color: white;
    border: none;
    width: 45px;
    height: 45px;
    border-radius: 50%;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
    backdrop-filter: blur(10px);
}

.shu-pdf-zoom-btn:hover {
    background: rgba(102, 126, 234, 0.9);
    transform: scale(1.1);
}

/* Bottom Controls */
.shu-pdf-bottom-controls {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 20px;
    padding: 12px 20px;
    background: white;
    border-top: 1px solid #e0e0e0;
    box-shadow: 0 -2px 10px rgba(0,0,0,0.05);
    min-height: 70px;
}

.shu-pdf-control-group {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 8px 12px;
    background: #f8f9fa;
    border-radius: 25px;
    border: 1px solid #e0e0e0;
}

.shu-pdf-control-btn {
    background: none;
    border: none;
    color: #666;
    padding: 8px 10px;
    border-radius: 6px;
    cursor: pointer;
    transition: all 0.2s ease;
    display: flex;
    align-items: center;
    justify-content: center;
    min-width: 36px;
    height: 36px;
}

.shu-pdf-control-btn:hover {
    background: #667eea;
    color: white;
    transform: translateY(-1px);
}

.shu-pdf-control-btn:disabled {
    opacity: 0.5;
    cursor: not-allowed;
}

.shu-pdf-control-btn:disabled:hover {
    background: none;
    color: #666;
    transform: none;
}

/* Hide dual page button since we're in single page mode */
#shu-pdf-dualPageBtn {
    display: none !important;
}

/* Status Bar */
.shu-pdf-status-bar {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 8px 20px;
    background: #f8f9fa;
    border-top: 1px solid #e0e0e0;
    font-size: 0.9rem;
    color: #666;
}

/* Loading Overlay */
.shu-pdf-loading-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(255,255,255,0.95);
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    z-index: 100;
    backdrop-filter: blur(5px);
}

.shu-pdf-loading-overlay.hidden {
    display: none;
}

.shu-pdf-loading-spinner {
    width: 50px;
    height: 50px;
    border: 4px solid #e0e0e0;
    border-top: 4px solid #667eea;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin-bottom: 15px;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Touch and Gesture Support */
.shu-pdf-page-canvas {
    touch-action: pan-x pan-y pinch-zoom;
}

/* Responsive Design - Single Page Optimized */
@media (max-width: 768px) {
    .shu-pdf-top-header {
        padding: 10px 15px;
    }
    
    .shu-pdf-branding h1 {
        font-size: 1.2rem;
    }
    
    .shu-pdf-page-display {
        gap: 6px;
        padding: 6px 10px;
    }
    
    .shu-pdf-display-container {
        height: calc(100vh - 140px);
    }
    
    .shu-pdf-wrapper {
        padding: 10px;
    }
    
    .shu-pdf-page-container {
        max-width: 98%;
        max-height: 98%;
    }
    
    .shu-pdf-bottom-controls {
        flex-wrap: wrap;
        gap: 10px;
        padding: 10px 15px;
    }
    
    .shu-pdf-control-group {
        gap: 6px;
        padding: 6px 10px;
    }
    
    .shu-pdf-control-btn {
        min-width: 32px;
        height: 32px;
        padding: 6px 8px;
    }
    
    .shu-pdf-side-panel {
        width: 280px;
        position: fixed;
        top: 0;
        left: 0;
        height: 100vh;
        z-index: 200;
    }
    
    .shu-pdf-nav-arrow {
        width: 40px;
        height: 40px;
        font-size: 1rem;
    }
    
    .shu-pdf-zoom-btn {
        width: 40px;
        height: 40px;
    }
}

@media (max-width: 480px) {
    .shu-pdf-page-info-top {
        flex-direction: column;
        gap: 8px;
    }
    
    .shu-pdf-bottom-controls {
        justify-content: space-between;
    }
    
    .shu-pdf-control-group {
        flex-wrap: wrap;
    }
}

/* Desktop Single Page Mode - Optimized for larger screens */
@media (min-width: 769px) {
    .shu-pdf-wrapper {
        padding: 30px;
    }
    
    .shu-pdf-page-container {
        max-width: 90%;
        max-height: 90%;
        min-width: 600px;
    }
    
    .shu-pdf-page-canvas {
        max-height: calc(100vh - 220px);
    }
}

/* Dark Theme */
.shu-pdf-dark-theme {
    background: #1a1a1a;
    color: #e0e0e0;
}

.shu-pdf-dark-theme .shu-pdf-viewer-container {
    background: #1a1a1a;
}

.shu-pdf-dark-theme .shu-pdf-display-container {
    background: #2d2d2d;
}

.shu-pdf-dark-theme .shu-pdf-side-panel {
    background: #2d2d2d;
    border-color: #404040;
}

.shu-pdf-dark-theme .shu-pdf-bottom-controls {
    background: #2d2d2d;
    border-color: #404040;
}

.shu-pdf-dark-theme .shu-pdf-control-group {
    background: #404040;
    border-color: #555;
}

.shu-pdf-dark-theme .shu-pdf-status-bar {
    background: #2d2d2d;
    border-color: #404040;
    color: #ccc;
}

/* Fullscreen Mode */
.shu-pdf-fullscreen {
    position: fixed !important;
    top: 0 !important;
    left: 0 !important;
    width: 100vw !important;
    height: 100vh !important;
    z-index: 9999 !important;
    background: #000 !important;
}

.shu-pdf-fullscreen .shu-pdf-wrapper {
    padding: 0;
}

.shu-pdf-fullscreen .shu-pdf-page-branding {
    display: none;
}

/* Zoom and Pan Indicators */
.shu-pdf-zoom-indicator {
    position: absolute;
    top: 20px;
    right: 20px;
    background: rgba(0,0,0,0.8);
    color: white;
    padding: 8px 12px;
    border-radius: 20px;
    font-size: 0.9rem;
    z-index: 30;
    backdrop-filter: blur(10px);
    opacity: 0;
    transition: opacity 0.3s ease;
}

.shu-pdf-zoom-indicator.visible {
    opacity: 1;
}

/* Single Page Specific Enhancements */
.shu-pdf-pages-container {
    gap: 0 !important; /* Remove gap since we only have one page */
}

/* Ensure right page container is always hidden */
#shu-pdf-rightPageContainer {
    display: none !important;
}
</style>
