<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<?php
require_once __DIR__.'/styles.php';
?>

<div class="shu-pdf-viewer-container">
    <!-- Top Header with Branding and Info -->
    <div class="shu-pdf-top-header">
        <div class="shu-pdf-branding">
            <h1><?php echo APP_NAME; ?></h1>
        </div>
        
        <button id="shu-pdf-toggleSidePanel" class="shu-pdf-side-panel-toggle" title="Toggle Page Panel">
            <i class="fas fa-list"></i>
        </button>
    </div>
    
    
        <!-- Bottom Controls -->
    <div class="shu-pdf-bottom-controls">
        <div class="shu-pdf-control-group">
            <button id="shu-pdf-firstPageBtn" class="shu-pdf-control-btn" title="First Page">
                <i class="fas fa-step-backward"></i>
            </button>
            <button id="shu-pdf-prevPageBtn" class="shu-pdf-control-btn" title="Previous Page">
                <i class="fas fa-chevron-left"></i>
            </button>
            <div class="shu-pdf-page-info-top">
            <div class="shu-pdf-page-display">
                <span>Page</span>
                <input type="number" id="shu-pdf-currentPageInput" min="1" value="1">
                <span>of</span>
                <span id="shu-pdf-totalPages">1</span>
            </div>
        </div>
            <button id="shu-pdf-nextPageBtn" class="shu-pdf-control-btn" title="Next Page">
                <i class="fas fa-chevron-right"></i>
            </button>
            <button id="shu-pdf-lastPageBtn" class="shu-pdf-control-btn" title="Last Page">
                <i class="fas fa-step-forward"></i>
            </button>
        </div>
        
        <div class="shu-pdf-control-group">
            <button id="shu-pdf-zoomOutBtn" class="shu-pdf-control-btn" title="Zoom Out">
                <i class="fas fa-search-minus"></i>
            </button>
                        <div class="shu-pdf-zoom-display-top">
                <span id="shu-pdf-zoomLevel">100%</span>
            </div>
            <button id="shu-pdf-zoomInBtn" class="shu-pdf-control-btn" title="Zoom In">
                <i class="fas fa-search-plus"></i>
            </button>
            <button id="shu-pdf-resetZoomBtn" class="shu-pdf-control-btn" title="Reset Zoom">
                <i class="fas fa-search"></i>
            </button>
        </div>

        <div class="shu-pdf-control-group">
            <button id="shu-pdf-fitWidthBtn" class="shu-pdf-control-btn" title="Fit Width">
                <i class="fas fa-arrows-alt-h"></i>
            </button>
            <button id="shu-pdf-fitPageBtn" class="shu-pdf-control-btn" title="Fit Page">
                <i class="fas fa-expand-arrows-alt"></i>
            </button>
            <button id="shu-pdf-dualPageBtn" class="shu-pdf-control-btn" title="Toggle Dual Page">
                <i class="fas fa-columns"></i>
            </button>
        </div>

        <div class="shu-pdf-control-group">
            <button id="shu-pdf-fullscreenBtn" class="shu-pdf-control-btn" title="Fullscreen">
                <i class="fas fa-expand"></i>
            </button>
            <button id="shu-pdf-rotateBtn" class="shu-pdf-control-btn" title="Rotate">
                <i class="fas fa-redo"></i>
            </button>
            <input type="file" id="shu-pdf-fileInput" accept=".pdf" style="display: none;">
            <button id="shu-pdf-loadFileBtn" class="shu-pdf-control-btn" title="Load PDF">
                <i class="fas fa-folder-open"></i>
            </button>
            <button id="shu-pdf-themeToggleBtn" class="shu-pdf-control-btn" title="Toggle Theme">
                <i class="fas fa-moon"></i>
            </button>
            <button id="shu-pdf-soundToggleBtn" class="shu-pdf-control-btn" title="Toggle Sound">
                <i class="fas fa-volume-up"></i>
            </button>
        </div>
    </div>

    <!-- Main Content Area -->
    <div class="shu-pdf-main-content">
        <!-- Side Panel for Page Navigation -->
        <div class="shu-pdf-side-panel" id="shu-pdf-sidePanel">
            <div class="shu-pdf-side-panel-header">
                <h3>Pages</h3>
                <button id="shu-pdf-closeSidePanel" class="shu-pdf-close-panel">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="shu-pdf-page-thumbnails" id="shu-pdf-pageThumbnails">
                <!-- Thumbnails will be generated here -->
            </div>
        </div>

        <!-- PDF Display Area -->
        <div class="shu-pdf-display-container" id="shu-pdf-pdfContainer">
    <div class="shu-pdf-wrapper" id="shu-pdf-wrapper">
        <!-- Desktop: Two pages side by side -->
        <div class="shu-pdf-pages-container" id="shu-pdf-pagesContainer">
            <div class="shu-pdf-page-container" id="shu-pdf-leftPageContainer">
                <div class="shu-pdf-page-branding"><?php echo APP_NAME; ?></div>
                <canvas id="shu-pdf-leftCanvas" class="shu-pdf-page-canvas"></canvas>
            </div>
            <div class="shu-pdf-page-container" id="shu-pdf-rightPageContainer">
                <div class="shu-pdf-page-branding"><?php echo APP_NAME; ?></div>
                <canvas id="shu-pdf-rightCanvas" class="shu-pdf-page-canvas"></canvas>
            </div>
        </div>
        
        <!-- Loading Overlay -->
        <!--<div class="shu-pdf-loading-overlay" id="shu-pdf-loadingOverlay">-->
        <!--    <div class="shu-pdf-loading-spinner"></div>-->
        <!--    <p>Loading PDF...</p>-->
        <!--</div>-->

        <!-- Navigation Overlay -->
        <div class="shu-pdf-nav-overlay">
            <button class="shu-pdf-nav-arrow shu-pdf-nav-prev" id="shu-pdf-navPrevBtn" title="Previous Page">
                <i class="fas fa-chevron-left"></i>
            </button>
            <button class="shu-pdf-nav-arrow shu-pdf-nav-next" id="shu-pdf-navNextBtn" title="Next Page">
                <i class="fas fa-chevron-right"></i>
            </button>
        </div>

        <!-- Zoom Controls Overlay -->
        <div class="shu-pdf-zoom-overlay">

        </div>
    </div>
</div>
    </div>



    <!-- Status Bar -->
    <div class="shu-pdf-status-bar">
        <div class="shu-pdf-status-info">
            <span id="shu-pdf-statusText">Ready to load PDF</span>
        </div>
        <div class="shu-pdf-quick-actions">
            <span class="shu-pdf-theme-indicator">
                <i class="fas fa-palette"></i>
                <span id="shu-pdf-themeText">Light</span>
            </span>
        </div>
    </div>
</div>

<!-- Audio for page turn sound -->
<audio id="shu-pdf-pageTurnSound" preload="auto">
    <source src="<?php echo APP_URL.'/Public/audio.mp3';?>" type="audio/mp3">
</audio>

<!-- PDF.js CDN -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.min.js"></script>
<?php
require_once __DIR__.'/script.php';
?>
