<?php
global $lang, $isLogin, $AuthUser;
$sett = false;
$query = '';
$gen =  new App\General\All();
$db =  new App\General\DB();
include('sidebar.php');

$query = Input('search');
$type = Input('type');
$limit = FILE_LIMIT;
$cPage = 1;
$page = Input('page') ? Input('page') : 1;
$offset = ($page - 1) * $limit;
$totalFiles = 0;
$totalpages = 0;

$rows = [];
$table = '';
$isLatest = false;
$cur_title = "Search";

if (Input('search')) {


    switch ($type) {

        case 'novel':
            $table =  'ebook';
            $title = "Ebooks";
            $isLatest = true;
            $rows = $db->table('ebook')->where('status', 1)->search(['name'], $query)->limit($limit)->offset($offset)->get();

            break;
        case 'author':
            $table =  'author';
            $title = "Authors";
            $slug = "author";


            $rows = $db->table('author as a')
                ->select([
                    'a.*',
                    "(SELECT COUNT(*) FROM ebook as e WHERE e.author LIKE CONCAT('%', a.name, '%')) as total_post"
                ])
                ->where('a.status', 1)
                ->search(['a.name'], $query)
                ->groupBy('a.id')
                ->orderBy('a.id', 'DESC')
                ->limit($limit)
                ->offset($offset)
                ->get();
            break;
        case 'group':

            $table = '`groups`';
            $title = "Association";
            $slug = "group";

            $rows = $db->table('`groups` as g')
                ->select([
                    'g.*',
                    "(SELECT COUNT(*) FROM ebook as e WHERE e.groupes LIKE CONCAT('%', g.name, '%')) as total_post"
                ])
                ->where('g.status', 1)
                ->search(['g.name'], $query)
                ->groupBy('g.id')
                ->orderBy('g.id', 'DESC')
                ->limit($limit)
                ->offset($offset)
                ->get();
            break;

        case 'compiler':

            $table = 'compiler';
            $title = "Compiler";
            $slug = "compiler";

            $rows = $db->table('compiler as c')
                ->select([
                    'c.*',
                    "(SELECT COUNT(*) FROM ebook as e WHERE e.compiler LIKE CONCAT('%', c.name, '%')) as total_post"
                ])
                ->where('c.status', 1)
                ->search(['c.name'], $query)
                ->groupBy('c.id')
                ->orderBy('c.id', 'DESC')
                ->limit($limit)
                ->offset($offset)
                ->get();
            break;
        case 'book':
            $table =  'book';
            $title = "Books Album";
            $slug = "book";

            $rows = $db->table('book as b')
                ->select(['b.*', '(SELECT COUNT(*) FROM ebook as e WHERE e.baid = b.id) as total_post'])
                ->where('b.status', 1)
                ->search(['b.name'], $query)
                ->orderBy('b.id', 'DESC')
                ->limit($limit)
                ->offset($offset)
                ->get();
            break;
        default:
            $rows = $db->table('ebook')->where('status', 1)->search(['name'], $query)->limit($limit)->offset($offset)->get();
            break;
    }

    $totalFiles = $db->table($table)->where('status', 1)->search(['name'], $query)->count();
    $totalpages = ceil($totalFiles / $limit);

   
    if (count($rows) < 1) {
        $title = "No result for search  " . $query;
    } else {
        $title = $query . " Search Result for ". $title;
    }

    $latests = $db->table('ebook')
        ->select('*')
        ->where('status', 1)
        ->orderBy('RAND()', '')
        ->limit(3)
        ->get();
} else {
    $title = "You did not search for anything";

    $latests = $db->table('ebook')
        ->select('*')
        ->where('status', 1)
        ->orderBy('RAND()', '')
        ->limit(3)
        ->get();
}
